--------------------------------------------------------------------
--            SymCACP Script Module Find POP and Generation Island Grows or Shrinks by percentages
-- Symmetrical CA Control Panel   symCACPscript-1
--file for finding if a random island expands or contracts
--Found that diamond 125 X 125 is equaly likly to expand or shrink smaller more likly to shrink
--larger more likly to expand
--
-- the search is crude as it assumes that the population changes monotonically which is false.
--------------------------------------------------------------------
--  P. Rendell  08/04/2023
--------------------------------------------------------------------

--
-- output 
-- RULE, WD, HT, SEED, GEO, SIZE, GEN0, GEN1, POP0, POP1, TYPE


------------------------------------------------------------

local scriptType = "script2-chaosIsle"
local m={}			-- class table
m.cnt = 0
local comProcs			-- common Procedures
local logFile
local g = golly()
local scriptFileData
local gr = require("buildUni") 
local gs = require("search") 
local gsb = require("search-band")
local gsc = require("search-chaos")
m.colonList = {['RULES'] = {"r","R"}, ['SEEDS'] = {"s","R"}, ['GEO'] = {'t',""}}
m.equalList = {['WIDTH'] = {"d","R"}, ['SIZE0'] = {"d",""}, ['SIZE1'] = {"d",""}, ['SIZED'] = {"d",""},
               ['LOGFILE'] = {'t',""}, ['RESULTS_OLD'] = {'t',""}, ['RESULTS_NEW'] = {'t',"R"},
               ['STEP1'] = {"d","R"}, ['MAX_PC'] = {"d","R"}, ['MIN_PC'] = {"d","R"},
               ['MAX_GEN'] = {'d',"R"}, ['INVERT'] = {'l',""} , ['INIT_FAC'] = {'d',""} }

------------------------------------------------------------------------------------------------
-- INIT_FAC 	initial run of island size by this factor to let the island assume a natural shape
-- STEP1 	first step of search for size change
-- MAX_PC	EXPAND: we wish to find the minimum generation that has this percentage of population at generation INIT_FAC * island
-- MIN_PC	SHRINK: we wish to find the maximum generation that has this percentage of population at generation INIT_FAC * island
-- MAX_GEN	Give up search at this generation
--==============================================================================
------------------------------------------------------------------------------------------------

function m.init(lf, cp)
   scriptFileData = {}
   comProcs = cp
   logFile = lf
end

------------------------------------------------------------------------------------------------
function m.buildParmVal(cmd, value, segNo)
   if (scriptFileData[cmd]) then
      comProcs.report.collect("Previous value overwriten "..cmd.." = "..value.."\n",true, segNo)
   end
   scriptFileData[cmd] = value
end

------------------------------------------------------------------------------------------------
function m.buildParmLst(cmd, parms, segNo)
   if (not scriptFileData[cmd]) then
      scriptFileData[cmd] = {}
   end
   for i, parm in pairs(parms) do
      table.insert(scriptFileData[cmd],parm)
   end
end

------------------------------------------------------------------------------------------------
function m.validateScript()
   local valid = true
   if not scriptFileData.HIGHT then
      scriptFileData.HIGHT = scriptFileData.WIDTH
   end
   if not scriptFileData.GEO then
      scriptFileData.GEO = {"R"}
   end
   if  scriptFileData.END_TYPE then
      valid =  ( scriptFileData.END_TYPE:sub(1,5) == "BREAK" ) or
               ( scriptFileData.END_TYPE == "CHAOS" ) or 
               ( scriptFileData.END_TYPE == "OLDCHAOS" ) or 
               ( scriptFileData.END_TYPE == "OLDOSC" ) or 
               ( scriptFileData.END_TYPE == "OSC" )
   end
   return valid
end



--==============================================================================

local function doFINDpopRes(outFile, res)
g.show("#t# "..res.GEN0..","..res.GEN1)
   outFile:write(string.format("%s,%i,%i,%s,%s,%i,%i,%i,%i,%i,%s\n",
                               m.rule, m.width, m.hight, m.seed, m.geo:sub(1,2), m.size, res.GEN0, res.GEN1, res.POP0, res.POP1, res.TYPE))
   outFile:flush()                                
end

--------------------------------------------------------------------------------

function openOutFile()
   local res = false
   local words = {}
   local key
   local inFile
   local test = true
   m.linesDone = {}
   logFile:write(' openOutFile\n')
   if scriptFileData then
      inFile = io.open ( scriptFileData.RESULTS_NEW , "r")
      if inFile then
         m.outFile = io.open ( scriptFileData.RESULTS_OLD , "w")
         if m.outFile then
            local line = inFile:read("*l")
            while line do
               m.outFile:write(line..'\n')
               line = inFile:read("*l")
            end
            inFile:close(); inFile = nil
            m.outFile:close(); m.outFile = nil
            m.outFile = io.open ( scriptFileData.RESULTS_NEW , "w")
            inFile = io.open ( scriptFileData.RESULTS_OLD , "r")
            if m.outFile and inFile then
               local line = inFile:read("*l")
               local cnt = 0
               while line do
--                  logFile:write('openOutFile line0 '..line..'\n')
                  if (line:sub(1,4) ~= "RULE") then
                     words = split(line)
                     if #words == 11 then
                        key = words[1]..':'..words[2]..':'..words[3]..':'..words[4]..':'..words[5]..':'..words[6]	--rule:wd:ht:seed:geo:size
                        if ( (not m.linesDone[key]  or (words[8] ~= 'maxEx')) and (words[8] ~= 'killed')  ) then
                           m.linesDone[key] = {GEN0 = words[7], GEN1 = words[8], POP0 = words[9], POP1 = words[10], TYPE = words[11]}
                           cnt = cnt + 1
                        end
                     else
                        logFile:write('openOutFile line '..line..' not 8 words\n')
                     end                     
                  end
                  line = inFile:read("*l")
               end 
               logFile:write('m.linesDone collected '..cnt..'\n')
               res = true
            else
               logFile:write("openOutFile (2nd) files not open infile:"..comProcs.bool2txt(inFile).." outfile:"..comProcs.bool2txt(m.outFile).."\n")
               res = false
               m.outFile:close(); m.outFile = nil
            end
            inFile:close(); inFile = nil
         else
            logFile:write("openOutFile (1st) files not open infile:"..comProcs.bool2txt(inFile).." outfile:"..comProcs.bool2txt(outFile).."\n")
            comProcs.report.collect('no RESULTS_OLD',false)
            inFile:close(); inFile = nil
            res = false
         end         
      else
         logFile:write("openOutFile no old file to copy\n")
         m.outFile = io.open(scriptFileData.RESULTS_NEW, "w")
         res = m.outFile ~= nil
      end
   else
      logFile:write("openOutFile no script file data\n")
      res = false
   end
   if (res) then
      m.outFile:write("RULE,WD,HT,SEED,GEO,SIZE,GEN0,GEN1,POP0,POP1,TYPE\n")
   end
   return res
end

------------------------------------------------------------

local function divertLog()
   res = true
   local log = io.open ( scriptFileData.LOGFILE , "w")
   if log then
      logFile:write('Diverting to logfile '..scriptFileData.LOGFILE..'\n')
      logDiverted = true
      logFile:close()
      logFile = log
      log = nil
      comProcs.newLog(logFile)
   else
      logFile:write('Failed to divert to logfile '..scriptFileData.LOGFILE..'\n')
      res = false
   end
   return res
end
------------------------------------------------------------

local function reDivertLog()
   if logDiverted then
      logFile:close()
      logFile = comProcs.oldLog()
      logFile:write('Continue after log diversion\n')
   end
   logDiverted = false
end
------------------------------------------------------------

function m.run(segmentNo)
   logFile:write('\ndoFINDEND-n\n')
   local test =true
   local logDiverted
   g.show('Find End Started')
   if scriptFileData then
      if scriptFileData.LOGFILE then
         logDiverted = divertLog(scriptFileData.LOGFILE)
      end
      comProcs.LogScript(segmentNo)
      if ( openOutFile() ) then
         m.cnt_done = 0
         m.cnt_DoneM = 0
         local OldOnly = true
         m.GetSamples(OldOnly)
         logFile:write('m.run done lines found = '..m.cnt_done..'\n')         
         OldOnly = false
         m.GetSamples(OldOnly)
         logFile:write('m.run done lines matched = '..m.cnt_DoneM..'\n')         
      end
   else
     comProcs.showTextOV('No Script file Loaded')
   end
   g.show('Finished')
   if (m.outFile ~= nil) then
      m.outFile:close();
      m.outFile = nil
   else
      comProcs.showTextOV('\nProblems copying old data\n')
   end
end
------------------------------------------------------------

local function findEndInit(pop0)
   m.minPop = pop0 * scriptFileData.MIN_PC // 100
   m.maxPop = pop0 * scriptFileData.MAX_PC // 100
   logFile:write("findEndInit population="..m.POP0.." min "..m.minPop.." max "..m.maxPop.." start\n")
   if(scriptFileData.INVERT) then
      local minPop = m.minPop
      m.minPop = (m.width * m.hight)/2 - m.maxPop
      m.maxPop = (m.width * m.hight)/2 - minPop
   end
   logFile:write("findEndInit population="..m.POP0.." min "..m.minPop.." max "..m.maxPop.."\n")
end
------------------------------------------------------------

function universeSaveUni()
   local s = {}
   s.result = 'none'
   s.restore =   function()
                    g.select({0,0,1,1})
   		       g.clear(1)
   		       g.clear(0)
   		       g.select({})
                    g.putcells(s.universe)
                    g.setgen(s.gen)
                 end
   s.setResult = function (res)
                    s.result = res
                 end
   s.getChanges =  function(o)	-- return the number of cells which have different states in uni s and uni o
                 end        
   s.gen = tonumber(g.getgen())
   s.pop = tonumber(g.getpop())
   s.pop = math.min(s.pop, m.maxCells - s.pop)
   s.universe = g.getcells({-(m.width//2), -(m.hight//2), m.width, m.hight})
   return s
end
--------------------------------------------------------------------

local function getUniverse()
   local uni = universeSaveUni()
   local pop = tonumber(g.getpop())
   if (pop < m.minPop) then
      uni.setResult("minpop")
   elseif (pop > m.maxPop) then
      uni.setResult("maxpop")
   end
   return (uni)
end
--------------------------------------------------------------------

local function FindEnd()
   local thisStep = math.floor(scriptFileData.STEP1)
   local universeBefore, universeAfter
   local event

--   logFile:write("FindEnd started 1 step1 "..thisStep.."\n")
   m.maxCells = m.width * m.hight
   m.keepGoing = true
   universeBefore = getUniverse() 
   universeAfter = universeBefore
   m.keepGoing = (universeBefore.result ~= 'osc') 
       
   while m.keepGoing do 
      g.run(thisStep)
      g.update()
      universeAfter = getUniverse()
      if (universeAfter.result ~= 'none') then
         if thisStep > 1 then
            thisStep = math.max(1, (thisStep+1)//2 )
            universeAfter = universeBefore
            universeAfter.restore()
         else
            m.keepGoing = false
         end
      else				-- no oscilation found
         if (universeAfter.gen < scriptFileData.MAX_GEN) then
            thisStep = math.max(2,thisStep + thisStep//2)
--               logFile:write("loopForOscEnd "..m.minPop..":"..m.maxPop.." "..m.geo.." max "..scriptFileData.MAX_GEN.." forward thisStep "..thisStep.." gen "..universeBefore.gen.."\n")
         else
            universeAfter.setResult("maxEx")
            m.keepGoing = false
            logFile:write("max exceeded finished gen "..universeAfter.gen.." max "..scriptFileData.MAX_GEN.."\n")
         end
      end
      g.show("loopForOscEnd "..m.minPop..":"..m.maxPop.." "..m.geo.." max "..scriptFileData.MAX_GEN.." forward thisStep "..thisStep.." gen "..universeBefore.gen.."\n")
--         logFile:write("thisStep "..thisStep.." seed "..m.seed.." max gen "..scriptFileData.MAX_GEN.." maxCells "..m.maxCells..' kg '..bool2txt(m.keepGoing)..'\n')
      if m.keepGoing then
         event = g.getevent()
         if (event:find("^key") or event:find("^oclick")) then
            logFile:write("FindEnd stoped by user action gen "..universeAfter.gen.."\n")
            universeAfter.setResult("killed")
            m.keepGoing = false
         end
      end
      universeBefore = universeAfter
   end
   m.oscPopList = nil
   universeBefore.restore()
   return universeAfter
end
--------------------------------------------------------------------

local function runOne(OldOnly)
   local res = 'none'
   local step1 =  scriptFileData.STEP1
   local key = m.rule..':'..m.seed..':'..m.geo:sub(1,2)..':'..m.size
   local maxGen = scriptFileData.MAX_GEN
   if(scriptFileData.INVERT) then
      gr.Switch_InvertIsland = true
   else
      gr.Switch_InvertIsland = false
   end
   if (OldOnly) then
      if ( m.linesDone[key] ) then
         doFINDpopRes(m.outFile, m.linesDone[key])
         m.cnt_done = m.cnt_done + 1
--         logFile:write('runOne old line key '..key..' POP0 '..m.linesDone[key].POP0..'\n')
      end
   elseif ( not m.linesDone[key] ) then
      gr.doBuild(' SymCACP FindEnd '..m.geo, m.width, m.hight, m.seed, m.geo:sub(1,2)..m.size, m.rule)  -- w, h, seed, rule, format
      g.run(scriptFileData.INIT_FAC * m.size)
      m.GEN0 = tonumber(g.getgen())
      m.POP0 = tonumber(g.getpop())
      if(scriptFileData.INVERT) then
         m.POP0 = (m.width * m.hight)/2 - m.POP0
      end
      findEndInit(m.POP0)
      local uni_res = FindEnd()
      m.GEN1 = tonumber(g.getgen())
      m.POP1 = tonumber(g.getpop())
      if(scriptFileData.INVERT) then
         m.POP1 = (m.width * m.hight)/2 - m.POP1
      end
      res = uni_res.result
      g.show(res..' seed '..m.seed..' gen '..tonumber(g.getgen()))
      doFINDpopRes(m.outFile, {GEN0 = m.GEN0, GEN1 = m.GEN1, POP0 = m.POP0, POP1 = m.POP1, TYPE = res})
      logFile:write('runOne End Found '..key..' POP1 '..uni_res.pop..' TYPE = '..res..'\n')
   else
      m.cnt_DoneM = m.cnt_DoneM + 1
   end
   return res
end
--------------------------------------------------------------------------

function m.GetSamples(OldOnly)
   local res = ''
   m.width = scriptFileData.WIDTH
   m.hight = m.width
   for Isize = scriptFileData.SIZE0,scriptFileData.SIZE1,scriptFileData.SIZED do
      m.size = Isize
      for ir = 1,#scriptFileData.RULES do
         m.rule = scriptFileData.RULES[ir]
         g.new('SymCACP Script '..scriptFileData.RESULTS_NEW..' '..m.rule..' ')
         for geoI,geo in pairs(scriptFileData.GEO) do
            m.geo = geo
            for is = 1,#scriptFileData.SEEDS do
               m.seed = scriptFileData.SEEDS[is]
               res = runOne(OldOnly)
               if res == 'killed' then break end
            end
            m.outFile:flush()
            if res == 'killed' then break end
         end
         if res == 'killed' then break end
      end
      if res == 'killed' then break end
   end
   if ((not OldOnly) and logDiverted) then
      logFile:flush()
      reDivertLog()
   end
end
return m
------------------------------------------------------------
